/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.server.dialogs.stringinput;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.remoteskin.server.dialogs.stringinput.CStringInputModel;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.server.dialogs.IStringInputDialog;
import de.sillysky.nyssr.remoteskin.server.listeners.IStringInputDialogListener;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CStringInputTarget
extends CTarget
implements IStringInputDialog {
    private final CStringInputModel mModel;

    public CStringInputTarget(@NotNull CStringInputModel aModel) {
        this.mModel = aModel;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (!aEnvelope.isAnswer()) {
            this.mModel.getUi().mountDialog();
            aEnvelope.setResultSuccess();
            return true;
        }
        return false;
    }

    public void setTitle(@NotNull String aTitle) {
        this.mModel.setTitle(aTitle);
    }

    public void setMessage(@NotNull String aMessage) {
        this.mModel.setMessage(aMessage);
    }

    public void setInitialInputValue(@NotNull String aValue) {
        this.mModel.setInitialInputValue(aValue);
    }

    public void setParent(@Nullable CWidgetId aParent) {
        this.mModel.setParent(aParent);
    }

    public void showDialog() throws CException {
        this.mModel.getUi().start();
    }

    public void setBackgroundColor(@NotNull Color aBackgroundColor) {
        this.mModel.setBackgroundColor(aBackgroundColor);
    }

    public void setForegroundColor(@NotNull Color aForegroundColor) {
        this.mModel.setForegroundColor(aForegroundColor);
    }

    @NotNull
    public String getText() {
        return this.mModel.getEnteredText();
    }

    public void setListeners(@NotNull List<IStringInputDialogListener> aListeners) {
        this.mModel.setListeners(aListeners);
    }

    public void addListener(@NotNull IStringInputDialogListener aListener) {
        this.mModel.getListeners().add(aListener);
    }
}

