svg = null;
simulation = null;
graphData = null;
link = null;
node = null;

// will be called when d3.js is loaded
function loadFile2() {

    // data
    [id_00402_nodes]


    // select svg element
    svg = d3.select("#id_00402_svg");

    svg.append("g").attr("class", "links");
    svg.append("g").attr("class", "nodes");

    // setup simulation
    simulation = d3.forceSimulation()
        .force("link", d3.forceLink().id(d => d.id).distance(100))
        .force("charge", d3.forceManyBody().strength(-300))
        .force("center", d3.forceCenter(400, 250));

    link = svg.selectAll(".link");
    node = svg.selectAll(".node");

    simulation.on("tick", ticked);

    updateGraph(graphData);
}

function updateGraph(data) {
    // Update the simulation with new data
    simulation.nodes(data.nodes);
    simulation.force("link").links(data.links);

    // Update links
    link = svg.select("g.links")
        .selectAll("line")
        .data(data.links, d => `${d.source.id}-${d.target.id}`);

    link.exit().remove();  // Remove old links

    const newLink = link.enter()
        .append("line")
        .attr("class", "link")
        //.attr("id", d => "id_link_from_" + d.source.id + "_to_" + d.target.id)
        .attr("id", d => "id_link_" + d.cid)
        .on("click", (event, d) => {
            console.log("Link clicked:", d);
            let message = {
                "cmd": "onClick2",
                //"id": "id_link_from_" + d.source.id + "_to_" + d.target.id,
                "id": "id_link_" + d.cid,
                "how": "left"
            }
            sendMessage(socket, message);
        });

    // Merge new and existing links
    link = newLink.merge(link);

    // Update nodes
    node = svg.select("g.nodes")
        .selectAll("g")
        .data(data.nodes, d => d.id);

    // Remove old nodes
    node.exit().remove();

    const newNode = node.enter()
        .append("g")
        .attr("class", "node")
        .attr("id", d => "id_node_" + d.id)
        .call(d3.drag()
            .on("start", dragstarted)
            .on("drag", dragged)
            .on("end", dragended))
        .on("click", (event, d) => {
            console.log("Node clicked:", d);
            let message = {
                "cmd": "onClick2",
                "id": "id_node_" + d.id,
                "how": "left"
            }
            sendMessage(socket, message);
        })
        .on("contextmenu", (event, d) => {
            event.preventDefault();
            console.log("Right-click on node:", d);
            let message = {
                "cmd": "onClick2",
                "id": "id_node_" + d.id,
                "how": "right"
            }
            sendMessage(socket, message);
        });

    newNode.append("circle")
        .attr("r", 30);

    newNode.append("text")
        .text(d => d.name);

    // Merge new and existing nodes
    node = newNode.merge(node);

    // Restart the simulation with new data
    simulation.alpha(1).restart();
}

function ticked() {
    link.attr("x1", d => d.source.x)
        .attr("y1", d => d.source.y)
        .attr("x2", d => d.target.x)
        .attr("y2", d => d.target.y);

    node.attr("transform", d => `translate(${d.x},${d.y})`);
}


function dragstarted(event, d) {
    if (!event.active) simulation.alphaTarget(0.3).restart();
    d.fx = d.x;
    d.fy = d.y;
}

function dragged(event, d) {
    d.fx = event.x;
    d.fy = event.y;
}

function dragended(event, d) {
    if (!event.active) simulation.alphaTarget(0);
    d.fx = null;
    d.fy = null;
}
